/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.util;

import java.lang.reflect.Array;

public class ByteSwapper {
    public static void swap(Object object) {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return;
            }
            if (clazz == Byte.TYPE) {
                return;
            }
            if (clazz == Character.TYPE) {
                return;
            }
            if (clazz == Short.TYPE) {
                ByteSwapper.swapShortArray(object);
            } else if (clazz == Integer.TYPE) {
                ByteSwapper.swapIntegerArray(object);
            } else if (clazz == Long.TYPE) {
                ByteSwapper.swapLongArray(object);
            } else if (clazz == Float.TYPE) {
                ByteSwapper.swapFloatArray(object);
            } else if (clazz == Double.TYPE) {
                ByteSwapper.swapDoubleArray(object);
            }
        }
    }

    private static void swapDoubleArray(Object object) {
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            double d = Array.getDouble(object, i);
            long l = Double.doubleToLongBits(d);
            long l2 = l >> 0 & 0xFFL;
            long l3 = l >> 8 & 0xFFL;
            long l4 = l >> 16 & 0xFFL;
            long l5 = l >> 24 & 0xFFL;
            long l6 = l >> 32 & 0xFFL;
            long l7 = l >> 40 & 0xFFL;
            long l8 = l >> 48 & 0xFFL;
            long l9 = l >> 56 & 0xFFL;
            l = l2 << 56 | l3 << 48 | l4 << 40 | l5 << 32 | l6 << 24 | l7 << 16 | l8 << 8 | l9 << 0;
            d = Double.longBitsToDouble(l);
            Array.setDouble(object, i, d);
        }
    }

    private static void swapFloatArray(Object object) {
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            float f = Array.getFloat(object, i);
            int n2 = Float.floatToIntBits(f);
            int n3 = n2 >> 0 & 0xFF;
            int n4 = n2 >> 8 & 0xFF;
            int n5 = n2 >> 16 & 0xFF;
            int n6 = n2 >> 24 & 0xFF;
            n2 = n3 << 24 | n4 << 16 | n5 << 8 | n6 << 0;
            f = Float.intBitsToFloat(n2);
            Array.setFloat(object, i, f);
        }
    }

    private static void swapIntegerArray(Object object) {
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            int n2 = Array.getInt(object, i);
            int n3 = n2 >> 0 & 0xFF;
            int n4 = n2 >> 8 & 0xFF;
            int n5 = n2 >> 16 & 0xFF;
            int n6 = n2 >> 24 & 0xFF;
            n2 = n3 << 24 | n4 << 16 | n5 << 8 | n6 << 0;
            Array.setInt(object, i, n2);
        }
    }

    private static void swapLongArray(Object object) {
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            long l = Array.getLong(object, i);
            long l2 = l >> 0 & 0xFFL;
            long l3 = l >> 8 & 0xFFL;
            long l4 = l >> 16 & 0xFFL;
            long l5 = l >> 24 & 0xFFL;
            long l6 = l >> 32 & 0xFFL;
            long l7 = l >> 40 & 0xFFL;
            long l8 = l >> 48 & 0xFFL;
            long l9 = l >> 56 & 0xFFL;
            l = l2 << 56 | l3 << 48 | l4 << 40 | l5 << 32 | l6 << 24 | l7 << 16 | l8 << 8 | l9 << 0;
            Array.setLong(object, i, l);
        }
    }

    private static void swapShortArray(Object object) {
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            short s = Array.getShort(object, i);
            int n2 = s >> 0 & 0xFF;
            int n3 = s >> 8 & 0xFF;
            s = (short)(n2 << 8 | n3 << 0);
            Array.setShort(object, i, s);
        }
    }
}

